SELECT sc.name AS TABLE_SCHEMA, o.name AS TABLE_NAME,
       s.name AS STATS_NAME,
       CASE WHEN index_id IS NULL
               THEN 'COLUMN'
            ELSE 'INDEX'
       END AS STATS_TYPE,
       STATS_DATE(s.object_id, s.stats_id) AS STATS_LAST_UPDATE,
       auto_created, user_created, no_recompute
FROM   sys.stats AS s
       LEFT OUTER JOIN sys.indexes AS i
            ON s.object_id = i.object_id
               AND s.name = i.name
       INNER JOIN sys.objects AS o
             ON s.object_id = o.object_id
       INNER JOIN sys.schemas AS sc
             ON o.schema_id = sc.schema_id;